<?php
// admin/index.php
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

    <style>
    body {
        background: #f8f9fa;
    }

    .card-menu {
        transition: all 0.3s ease;
        cursor: pointer;
    }

    .card-menu:hover {
        transform: translateY(-5px);
        box-shadow: 0px 8px 20px rgba(0, 0, 0, 0.1);
    }

    .navbar-brand {
        font-weight: bold;
    }
    </style>
</head>

<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="#">📋 Buku Tamu</a>
        </div>
    </nav>

    <!-- Content -->
    <div class="container py-5">
        <div class="text-center mb-5">
            <h1 class="fw-bold">Dashboard Admin</h1>
            <p class="text-muted">Kelola tamu dan ucapan dalam satu tempat</p>
        </div>

        <div class="row g-4 justify-content-center">
            <!-- Card Kelola Tamu -->
            <div class="col-md-4 col-sm-6">
                <a href="tamu.php" class="text-decoration-none text-dark">
                    <div class="card card-menu shadow-sm text-center p-4">
                        <div class="mb-3">
                            <i class="bi bi-people fs-1 text-primary"></i>
                        </div>
                        <h5 class="fw-bold">Kelola Tamu</h5>
                        <p class="text-muted small">Tambah, ubah, dan hapus data tamu undangan</p>
                    </div>
                </a>
            </div>

            <!-- Card Lihat Ucapan -->
            <div class="col-md-4 col-sm-6">
                <a href="ucapan.php" class="text-decoration-none text-dark">
                    <div class="card card-menu shadow-sm text-center p-4">
                        <div class="mb-3">
                            <i class="bi bi-chat-dots fs-1 text-success"></i>
                        </div>
                        <h5 class="fw-bold">Lihat Ucapan</h5>
                        <p class="text-muted small">Baca pesan & doa dari para tamu</p>
                    </div>
                </a>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>